/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuildingWorkerView;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.BuildingHiringModeMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildingWorkerView
extends AbstractBuildingView
implements IBuildingWorkerView {
    private final Set<Integer> workerIDs = new HashSet<Integer>();
    private HiringMode hiringMode;
    private String jobName;
    private int maxInhabitants = 1;
    private Skill primary = Skill.Intelligence;
    private Skill secondary = Skill.Intelligence;
    private String jobDisplayName;

    public AbstractBuildingWorkerView(IColonyView c, @NotNull BlockPos l) {
        super(c, l);
    }

    @Override
    public List<Integer> getWorkerId() {
        return new ArrayList<Integer>(this.workerIDs);
    }

    @Override
    public void addWorkerId(int workerId) {
        this.workerIDs.add(workerId);
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        super.deserialize(buf);
        int size = buf.readInt();
        this.workerIDs.clear();
        for (int i = 0; i < size; ++i) {
            this.workerIDs.add(buf.readInt());
        }
        this.hiringMode = HiringMode.values()[buf.readInt()];
        this.jobName = buf.func_150789_c(Short.MAX_VALUE);
        this.maxInhabitants = buf.readInt();
        this.primary = Skill.values()[buf.readInt()];
        this.secondary = Skill.values()[buf.readInt()];
        this.maxInhabitants = buf.readInt();
        this.jobDisplayName = buf.func_218666_n();
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return this.primary;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return this.secondary;
    }

    @Override
    public void removeWorkerId(int id) {
        this.workerIDs.remove(id);
    }

    @Override
    public boolean hasEnoughWorkers() {
        return !this.workerIDs.isEmpty();
    }

    @Override
    public HiringMode getHiringMode() {
        return this.hiringMode;
    }

    @Override
    public void setHiringMode(HiringMode hiringMode) {
        this.hiringMode = hiringMode;
        Network.getNetwork().sendToServer(new BuildingHiringModeMessage(this, hiringMode));
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    public boolean canAssign(ICitizenDataView citizenDataView) {
        return true;
    }

    public int getMaxInhabitants() {
        return this.maxInhabitants;
    }

    @Override
    public String getJobDisplayName() {
        return this.jobDisplayName;
    }
}

